<?php

namespace App\Modules\Secretariat\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Appointments extends Model 
{

    protected $table = 'appointments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('appointment_date', 'title');

    public function manger()
    {
        return $this->belongsTo('App\Modules\HR\Entities\Employee', 'employee_id');
    }

}